﻿Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Linq
Imports System.Text
Imports System.Windows.Forms
Imports VBEloPubInterface.VBEloPubInterface


Public Class EloPubForm

    Public m_nScrNo As UInt32 = 0

    Private Sub EloPubForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        textBoxScreenIdx.Clear()
        textBoxScreenIdx.Focus()
        textBoxScreenIdx.AppendText("0")

        Dim nRet As Integer = 0
        Dim count As New Int32()
        Dim dwMonNo As UInt32() = New UInt32(255) {}
        nRet = EloPubIf.EloGetScreenInfo(dwMonNo, count)
        textBoxScreenCount.Clear()
        textBoxScreenCount.AppendText(count.ToString())

        m_nScrNo = Convert.ToUInt32(textBoxScreenIdx.Text, 10)
        Dim pDragDelay As New DRAG_DELAY()
        nRet = EloPubIf.EloGetDragDelay(pDragDelay, m_nScrNo)
        trackDragDelayBar.Value = CInt(pDragDelay.DragDelay)

        Dim psndVal As New BEEP()
        nRet = EloPubIf.EloGetBeep(psndVal, m_nScrNo)

        checkBoxBeepOnTouch.Checked = Not (psndVal.BeepFlag = 0)
        trackToneBar.Value = CInt(psndVal.BeepFreq)
        trackDurationBar.Value = CInt(psndVal.BeepTime)

        If psndVal.UseExternalSpeaker = 0 Then
            radioBtonMothSpeaker.[Select]()
        Else
            radioBtnExtSpeaker.[Select]()
        End If

        Dim pwMode As New Int16()
        EloPubIf.EloGetMouseMode(pwMode, m_nScrNo)

        Select Case pwMode
            Case 6
                radioBtnMouseEmu.[Select]()
                Exit Select
            Case 1
                radioBtnCORelease.[Select]()
                Exit Select
            Case 0
                radioBtnCOTouch.[Select]()
                Exit Select
            Case Else

                radioBtnCOTouch.[Select]()
                Exit Select
        End Select

        Dim pUTimeout As New UNTOUCH_TIMEOUT()
        nRet = EloPubIf.EloGetUntouchTimeout(pUTimeout, m_nScrNo)
        textBoxUntouchTimeout.Clear()
        textBoxUntouchTimeout.AppendText(DirectCast(pUTimeout.TimeOut.ToString(), String))

    End Sub

    Private Sub btnApply_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnApply.Click
        Dim nRet As Integer = 0

        Dim psndVal As New BEEP()
        nRet = EloPubIf.EloSetBeep(psndVal, m_nScrNo)
        psndVal.BeepFlag = If(checkBoxBeepOnTouch.Checked, 1, 0)
        psndVal.BeepFreq = CUInt(trackToneBar.Value)
        psndVal.BeepTime = CUInt(trackDurationBar.Value)
        psndVal.UseExternalSpeaker = If(radioBtnExtSpeaker.Checked, 1, 0)
        nRet = EloPubIf.EloSetBeep(psndVal, m_nScrNo)
        trackToneBar.Enabled = True
        trackDurationBar.Enabled = True
        trackToneBar.Invalidate()
        trackDurationBar.Invalidate()

        Dim nMouseMode As Int16 = 6
        If radioBtnMouseEmu.Checked Then
            nMouseMode = 6
        ElseIf radioBtnCORelease.Checked Then
            nMouseMode = 1
        ElseIf radioBtnCOTouch.Checked Then
            nMouseMode = 0
        End If
        nRet = EloPubIf.EloSetMouseMode(nMouseMode, m_nScrNo)

        Dim pDragDelay As New DRAG_DELAY()
        pDragDelay.DragDelay = CUInt(trackDragDelayBar.Value)


        nRet = EloPubIf.EloSetDragDelay(pDragDelay, m_nScrNo)

        Dim pUTimeout As New UNTOUCH_TIMEOUT()
        pUTimeout.TimeOut = Convert.ToUInt32(textBoxUntouchTimeout.Text, 10)
        nRet = EloPubIf.EloSetUntouchTimeout(pUTimeout, m_nScrNo)

    End Sub

    Private Sub checkBoxBeepOnTouch_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles checkBoxBeepOnTouch.CheckedChanged
        Dim m_nScrNo As UInt32 = 0
        Dim nRet As Integer = 0
        Dim psndVal As New BEEP()
        psndVal.BeepFlag = If(checkBoxBeepOnTouch.Checked, 1, 0)
        If Not checkBoxBeepOnTouch.Checked Then
            trackToneBar.Enabled = False
            trackDurationBar.Enabled = False
        Else
            nRet = EloPubIf.EloGetBeep(psndVal, m_nScrNo)
            trackToneBar.Value = CInt(psndVal.BeepFreq)
            trackDurationBar.Value = CInt(psndVal.BeepTime)
            trackToneBar.Enabled = True
            trackDurationBar.Enabled = True
        End If
        checkBoxBeepOnTouch.Invalidate()
        trackToneBar.Invalidate()
        trackDurationBar.Invalidate()

    End Sub

    Private Sub textBoxScreenIdx_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles textBoxScreenIdx.TextChanged
        m_nScrNo = Convert.ToUInt32(textBoxScreenIdx.Text, 10)
    End Sub
End Class
